/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackWearable;
import com.tiviacz.travelersbackpack.commands.AccessBackpackCommand;
import com.tiviacz.travelersbackpack.commands.ClearBackpackCommand;
import com.tiviacz.travelersbackpack.commands.RestoreBackpackCommand;
import com.tiviacz.travelersbackpack.commands.UnpackBackpackCommand;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.BackpackManager;
import com.tiviacz.travelersbackpack.common.recipes.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.common.recipes.ShapedBackpackRecipe;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.items.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundSendMessagePacket;
import com.tiviacz.travelersbackpack.network.ClientboundSyncCapabilityPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.LogHelper;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.command.ConfigCommand;

@Mod.EventBusSubscriber(modid="travelersbackpack", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    private static boolean checkAbilitiesForRemoval = true;
    private static long nextBackpackCountCheck = 0L;
    private static final int BACKPACK_COUNT_CHECK_COOLDOWN = 100;

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ITravelersBackpack.class);
    }

    @SubscribeEvent
    public static void playerSetSpawn(PlayerSetSpawnEvent event) {
        Level level = event.getEntity().m_9236_();
        if (event.getNewSpawn() != null) {
            Block block = level.m_8055_(event.getNewSpawn()).m_60734_();
            if (!level.f_46443_ && block instanceof SleepingBagBlock && !event.isForced()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity backpack;
        BlockEntity list;
        BlockEntity oldSleepingBag;
        TravelersBackpackBlockEntity blockEntity;
        BlockEntity context;
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (((Boolean)TravelersBackpackConfig.COMMON.backpackSettings.enableBackpackRightClickUnequip.get()).booleanValue() && !TravelersBackpack.enableCurios() && CapabilityUtils.isWearingBackpack(player) && !level.f_46443_ && player.m_6144_() && hand == InteractionHand.MAIN_HAND && player.m_21205_().m_41619_()) {
            TravelersBackpackItem item;
            Item item2;
            ItemStack backpackStack = CapabilityUtils.getWearingBackpack(player);
            context = new UseOnContext(level, player, hand, backpackStack, event.getHitVec());
            boolean quickPickupFlag = level.m_8055_(pos).m_60734_() instanceof TravelersBackpackBlock;
            if (!quickPickupFlag && (item2 = backpackStack.m_41720_()) instanceof TravelersBackpackItem && (item = (TravelersBackpackItem)item2).m_40576_(new BlockPlaceContext((UseOnContext)context)) == InteractionResult.m_19078_((boolean)level.f_46443_)) {
                player.m_21011_(hand, true);
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.05f, (1.0f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f) * 0.7f);
                CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::removeWearable);
                CapabilityUtils.synchronise(player);
                CapabilityUtils.synchroniseToOthers(player);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
        }
        if (player.m_6144_() && hand == InteractionHand.MAIN_HAND && player.m_21205_().m_204117_(ModTags.SLEEPING_BAGS) && (context = level.m_7702_(pos)) instanceof TravelersBackpackBlockEntity) {
            blockEntity = (TravelersBackpackBlockEntity)context;
            oldSleepingBag = blockEntity.getProperSleepingBag().m_60734_().m_5456_().m_7968_();
            blockEntity.setSleepingBagColor(ShapedBackpackRecipe.getProperColor(player.m_21205_().m_41720_()));
            if (!level.f_46443_) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_7494_().m_123342_(), (double)pos.m_123343_(), (ItemStack)oldSleepingBag);
                stack.m_41774_(1);
            }
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (player.m_6144_() && player.m_21205_().m_41720_() == ModItems.BLANK_UPGRADE.get() && (oldSleepingBag = level.m_7702_(pos)) instanceof TravelersBackpackBlockEntity) {
            int fluidAmountRight;
            int fluidAmountLeft;
            blockEntity = (TravelersBackpackBlockEntity)oldSleepingBag;
            list = NonNullList.m_122779_();
            for (int i = 0; i < blockEntity.getCombinedHandler().getSlots(); ++i) {
                ItemStack stackInSlot = blockEntity.getCombinedHandler().getStackInSlot(i);
                if (stackInSlot.m_41619_()) continue;
                list.add((Object)stackInSlot);
                blockEntity.getCombinedHandler().setStackInSlot(i, ItemStack.f_41583_);
            }
            list.addAll(UpgradeItem.getUpgrades(blockEntity));
            if (!blockEntity.getSlotManager().getUnsortableSlots().isEmpty()) {
                blockEntity.getSlotManager().getUnsortableSlots().clear();
            }
            if (!blockEntity.getSlotManager().getMemorySlots().isEmpty()) {
                blockEntity.getSlotManager().getMemorySlots().clear();
            }
            int n = fluidAmountLeft = blockEntity.getLeftTank().isEmpty() ? 0 : blockEntity.getLeftTank().getFluidAmount();
            if (fluidAmountLeft > Tiers.LEATHER.getTankCapacity()) {
                blockEntity.getLeftTank().drain(fluidAmountLeft - Tiers.LEATHER.getTankCapacity(), IFluidHandler.FluidAction.EXECUTE);
            }
            int n2 = fluidAmountRight = blockEntity.getRightTank().isEmpty() ? 0 : blockEntity.getRightTank().getFluidAmount();
            if (fluidAmountRight > Tiers.LEATHER.getTankCapacity()) {
                blockEntity.getRightTank().drain(fluidAmountRight - Tiers.LEATHER.getTankCapacity(), IFluidHandler.FluidAction.EXECUTE);
            }
            if (!level.f_46443_) {
                Containers.m_19010_((Level)level, (BlockPos)pos.m_7494_(), (NonNullList)list);
            }
            blockEntity.getHandler().setSize(Tiers.LEATHER.getStorageSlots());
            blockEntity.getToolSlotsHandler().setSize(Tiers.LEATHER.getToolSlots());
            blockEntity.resetTier();
            blockEntity.getLeftTank().setCapacity(Tiers.LEATHER.getTankCapacity());
            blockEntity.getRightTank().setCapacity(Tiers.LEATHER.getTankCapacity());
            blockEntity.getSettingsManager().loadDefaults();
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        if (((Boolean)TravelersBackpackConfig.COMMON.backpackSettings.enableBackpackBlockWearable.get()).booleanValue() && (list = level.m_7702_(pos)) instanceof TravelersBackpackBlockEntity) {
            blockEntity = (TravelersBackpackBlockEntity)list;
            if (player.m_6144_() && !CapabilityUtils.isWearingBackpack(player) && !TravelersBackpack.enableCurios()) {
                backpack = new ItemStack((ItemLike)level.m_8055_(pos).m_60734_(), 1);
                blockEntity.transferToItemStack((ItemStack)backpack);
                Direction direction = (Direction)level.m_8055_(pos).m_61143_((Property)TravelersBackpackBlock.FACING);
                if (!level.f_46443_ && level.m_46597_(pos, Blocks.f_50016_.m_49966_())) {
                    CapabilityUtils.equipBackpack(player, (ItemStack)backpack);
                    blockEntity.removeSleepingBag(level, direction);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    return;
                }
            }
        }
        if ((backpack = level.m_7702_(pos)) instanceof TravelersBackpackBlockEntity) {
            blockEntity = (TravelersBackpackBlockEntity)backpack;
            if (player.m_6144_() && hand == InteractionHand.MAIN_HAND && player.m_21205_().m_41619_()) {
                backpack = new ItemStack((ItemLike)level.m_8055_(pos).m_60734_(), 1);
                blockEntity.transferToItemStack((ItemStack)backpack);
                Direction direction = (Direction)level.m_8055_(pos).m_61143_((Property)TravelersBackpackBlock.FACING);
                if (!level.f_46443_ && level.m_46597_(pos, Blocks.f_50016_.m_49966_())) {
                    player.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)backpack);
                    blockEntity.removeSleepingBag(level, direction);
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    return;
                }
            }
        }
        if (event.getLevel().f_46443_ || event.getEntity().m_6144_()) {
            return;
        }
        if (stack.m_41720_() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            BlockState blockState = level.m_8055_(pos);
            if (BackpackDyeRecipe.hasColor(stack) && blockState.m_60734_() instanceof LayeredCauldronBlock && (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) > 0) {
                stack.m_41783_().m_128473_("Color");
                LayeredCauldronBlock.m_153559_((BlockState)blockState, (Level)level, (BlockPos)pos);
                level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123342_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onEnderManAngerEvent(EnderManAngerEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.pumpkinAbility(event);
        }
    }

    @SubscribeEvent
    public static void blockBlazeProjectile(ProjectileImpactEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.blazeAbility(event);
        }
    }

    @SubscribeEvent
    public static void livingChangeTarget(LivingChangeTargetEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.ghastAbility(event);
        }
    }

    @SubscribeEvent
    public static void onHit(AttackEntityEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.beeAbility(event);
        }
    }

    @SubscribeEvent
    public static void onExpPickup(PlayerXpEvent.PickupXp event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.ABILITIES.lapisAbility(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CapabilityUtils.synchronise(player);
        }
    }

    @SubscribeEvent
    public static void finalizeSpawnEvent(MobSpawnEvent.FinalizeSpawn event) {
        if (((Boolean)TravelersBackpackConfig.COMMON.world.spawnEntitiesWithBackpack.get()).booleanValue() && event.getEntity().m_6844_(EquipmentSlot.CHEST).m_41619_() && Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntity().m_6095_()) && (double)event.getLevel().m_213780_().m_188501_() < (Double)TravelersBackpackConfig.COMMON.world.chance.get()) {
            boolean isNether = event.getEntity().m_6095_() == EntityType.f_20511_ || event.getEntity().m_6095_() == EntityType.f_20497_;
            RandomSource rand = event.getLevel().m_213780_();
            ItemStack backpack = isNether ? ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.get(rand.m_216332_(0, ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.size() - 1)).m_7968_() : ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.get(rand.m_216332_(0, ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.size() - 1)).m_7968_();
            backpack.m_41784_().m_128405_("SleepingBagColor", DyeColor.values()[rand.m_216332_(0, DyeColor.values().length - 1)].m_41060_());
            event.getEntity().m_8061_(EquipmentSlot.CHEST, backpack);
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            TravelersBackpackWearable travelersBackpack = new TravelersBackpackWearable(player);
            event.addCapability(TravelersBackpackCapability.ID, TravelersBackpackCapability.createProvider(travelersBackpack));
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && CapabilityUtils.isWearingBackpack(player = (Player)livingEntity) && TravelersBackpackConfig.enableBackpackAbilities && BackpackAbilities.creeperAbility(event)) {
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerDrops(LivingDropsEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && CapabilityUtils.isWearingBackpack(player = (Player)livingEntity)) {
            if (TravelersBackpack.enableCurios()) {
                if (!player.m_9236_().f_46443_) {
                    BackpackManager.addBackpack((ServerPlayer)player, CapabilityUtils.getWearingBackpack(player));
                }
                CapabilityUtils.getCapability(player).ifPresent(cap -> {
                    cap.removeWearable();
                    cap.synchronise();
                    cap.synchroniseToOthers(player);
                });
                return;
            }
            if (player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                return;
            }
            ItemStack stack = CapabilityUtils.getWearingBackpack(player);
            if (BackpackUtils.onPlayerDrops(player.m_9236_(), player, stack)) {
                if (player.m_9236_().f_46443_) {
                    return;
                }
                ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                itemEntity.m_32060_();
                TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientboundSendMessagePacket(true, player.m_20183_()));
                if (!TravelersBackpack.isAnyGraveModInstalled()) {
                    LogHelper.info("There's no space for backpack. Dropping backpack item at X: " + player.m_20183_().m_123341_() + " Y: " + player.m_20186_() + " Z: " + player.m_20183_().m_123343_(), new Object[0]);
                }
                event.getDrops().add(itemEntity);
                CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::removeWearable);
                CapabilityUtils.synchronise(player);
            }
        }
        if (Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntity().m_6095_()) && event.getEntity().m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof TravelersBackpackItem) {
            if (!(event.getSource().m_7639_() instanceof Player)) {
                return;
            }
            ItemEntity itemEntity = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), event.getEntity().m_6844_(EquipmentSlot.CHEST));
            event.getDrops().add(itemEntity);
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        oldPlayer.revive();
        CapabilityUtils.getCapability(oldPlayer).ifPresent(oldTravelersBackpack -> CapabilityUtils.getCapability(event.getEntity()).ifPresent(newTravelersBackpack -> {
            newTravelersBackpack.setWearable(oldTravelersBackpack.getWearable());
            newTravelersBackpack.setContents(oldTravelersBackpack.getWearable());
        }));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilityUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void playerTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof Player && !event.getTarget().m_9236_().f_46443_) {
            ServerPlayer target = (ServerPlayer)event.getTarget();
            CapabilityUtils.getCapability((Player)target).ifPresent(c -> TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new ClientboundSyncCapabilityPacket(target.m_19879_(), true, CapabilityUtils.getWearingBackpack((Player)target).m_41739_(new CompoundTag()))));
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities && event.phase == TickEvent.Phase.END && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, CapabilityUtils.getWearingBackpack(event.player))) {
            TravelersBackpackContainer.abilityTick(event.player);
            if (!checkAbilitiesForRemoval && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, CapabilityUtils.getWearingBackpack(event.player))) {
                checkAbilitiesForRemoval = true;
            }
        }
        if (!(!checkAbilitiesForRemoval || event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_ || CapabilityUtils.isWearingBackpack(event.player) && TravelersBackpackConfig.enableBackpackAbilities)) {
            BackpackAbilities.ABILITIES.armorAbilityRemovals(event.player);
            checkAbilitiesForRemoval = false;
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !TravelersBackpackConfig.tooManyBackpacksSlowness || nextBackpackCountCheck > event.level.m_46467_()) {
            return;
        }
        nextBackpackCountCheck = event.level.m_46467_() + 100L;
        event.level.m_6907_().forEach(player -> {
            if (player.m_7500_() || player.m_5833_()) {
                return;
            }
            AtomicInteger numberOfBackpacks = ForgeEventHandler.checkBackpacksForSlowness(player);
            if (numberOfBackpacks.get() == 0) {
                return;
            }
            int maxNumberOfBackpacks = TravelersBackpackConfig.maxNumberOfBackpacks;
            if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((double)(numberOfBackpacks.get() - maxNumberOfBackpacks) * TravelersBackpackConfig.slownessPerExcessedBackpack));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, numberOfSlownessLevels - 1, false, false));
            }
        });
    }

    public static AtomicInteger checkBackpacksForSlowness(Player player) {
        AtomicInteger atomic = new AtomicInteger(0);
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            if (!(((ItemStack)player.m_150109_().f_35974_.get(i)).m_41720_() instanceof TravelersBackpackItem)) continue;
            atomic.incrementAndGet();
        }
        if (((ItemStack)player.m_150109_().f_35976_.get(0)).m_41720_() instanceof TravelersBackpackItem) {
            atomic.incrementAndGet();
        }
        return atomic;
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        new AccessBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new RestoreBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ClearBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new UnpackBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void explosionDetonate(ExplosionEvent.Detonate event) {
        for (int i = 0; i < event.getAffectedBlocks().size(); ++i) {
            if (!(event.getLevel().m_8055_((BlockPos)event.getAffectedBlocks().get(i)).m_60734_() instanceof TravelersBackpackBlock)) continue;
            event.getAffectedBlocks().remove(i);
        }
    }

    @SubscribeEvent
    public static void addVillagerTrade(VillagerTradesEvent event) {
        if (TravelersBackpackConfig.enableVillagerTrade && event.getType() == VillagerProfession.f_35594_) {
            ((List)event.getTrades().get(3)).add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, random.m_188503_(64) + 48), new ItemStack((ItemLike)((Item)ModItems.VILLAGER_TRAVELERS_BACKPACK.get()).m_5456_(), 1), 1, 50, 0.5f));
        }
    }
}

